clear all

% ----------------------------------------------------------------------- %
% Complete the following code:
% Modify here to your folder
cd 'FILL HERE'

% -------------------------------- END ---------------------------------- %

% Imports data of a single pixel
pix = importdata('FILL HERE');

% Seperates fine and coarse time stamps
coarse = pix(:,2);
fine = pix(:,1);

% Finds marker positions, -56 is the marker for counter reset
Ind = find(fine == -56);

% Initilize number of events holder
Tot = zeros(1,10);

% Seperates the data between markers (-56) and calculates number of events
% within a single period
for i = 1:1:length(Ind)
    if i == length(Ind)
        Sep = coarse(Ind(i):end-1); % A section of the coarse timestamps (between two -56 markers)

        fine2 = fine(Ind(i):end-1);
        Ind2 = find(fine2 == -9);   % To remove dwell markers

        Sep(Ind2) = [];
        [~,~,ix] = unique(Sep);
        C = accumarray(ix,1).';
        [~,~,ix] = unique(C);
        C2 = accumarray(ix,1).';
    else
        Sep = coarse(Ind(i):Ind(i+1)-1);    % A section of the coarse timestamps (between two -56 markers)
        fine2 = fine(Ind(i):Ind(i+1)-1);
        Ind2 = find(fine2 == -9);

        Sep(Ind2) = [];
        [~,~,ix] = unique(Sep);
        C = accumarray(ix,1).';
        [~,~,ix] = unique(C);
        C2 = accumarray(ix,1).';    % Number of nonzero detection events within a section
    end
    Zero_Count(i) = sum(diff(Sep)-1); % # of zero events

    Tot(1:length(C2)) = Tot(1:length(C2)) + C2; % Number of nonzero detection events
end


hh = [sum(Zero_Count) Tot]; % Histogram of number of events for 0,1,2...

% ----------------------------------------------------------------------- %
% Complete the following code:
% Plot the histogram

figure

% -------------------------------- END ---------------------------------- %


